/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.entity.data;

import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.api.CustomNPCsException;
import noppes.npcs.api.entity.data.IAttributeSet;
import noppes.npcs.entity.data.DropSet;
import noppes.npcs.util.ValueUtil;

public class AttributeSet
implements IAttributeSet {
    public IAttribute attr;
    public double chance;
    public DropSet parent;
    public int slot;
    public double[] values;

    public AttributeSet(DropSet p) {
        this.parent = p;
        this.values = new double[]{0.0, 0.05};
        this.attr = SharedMonsterAttributes.field_111267_a;
        this.chance = 100.0;
        this.slot = 0;
    }

    @Override
    public String getAttribute() {
        return this.attr.func_111108_a();
    }

    @Override
    public double getChance() {
        return (double)Math.round(this.chance * 10000.0) / 10000.0;
    }

    public String getKey() {
        String keyName = "";
        char c = '\u00a7';
        double ch = (double)Math.round(this.chance * 10.0) / 10.0;
        String chance = String.valueOf(ch).replace(".", ",");
        if (ch == (double)((int)ch)) {
            chance = String.valueOf((int)ch);
        }
        chance = chance + "%";
        keyName = keyName + c + "e" + chance;
        double v0 = (double)Math.round(this.values[0] * 1000.0) / 1000.0;
        String tv0 = String.valueOf(v0).replace(".", ",");
        if (v0 == (double)((int)v0)) {
            tv0 = String.valueOf((int)v0);
        }
        double v1 = (double)Math.round(this.values[1] * 1000.0) / 1000.0;
        String tv1 = String.valueOf(v1).replace(".", ",");
        if (v1 == (double)((int)v1)) {
            tv1 = String.valueOf((int)v1);
        }
        keyName = this.values[0] == this.values[1] ? keyName + c + "7[" + c + "6" + tv0 + c + "7] " : keyName + c + "7[" + c + "6" + tv0 + c + "7-" + c + "6" + tv1 + c + "7] ";
        String name = new TextComponentTranslation("attribute.name." + this.attr.func_111108_a(), new Object[0]).func_150254_d();
        if (name.equals("attribute.name." + this.attr.func_111108_a()) || name.equals("attribute.name.")) {
            name = this.attr.func_111108_a();
        }
        keyName = keyName + c + "r" + name;
        keyName = keyName + c + "8 #" + this.toString().substring(this.toString().indexOf("@") + 1);
        return keyName;
    }

    @Override
    public double getMaxValue() {
        return this.values[1];
    }

    @Override
    public double getMinValue() {
        return this.values[0];
    }

    public NBTTagCompound getNBT() {
        NBTTagCompound nbtAS = new NBTTagCompound();
        NBTTagList list = new NBTTagList();
        list.func_74742_a((NBTBase)new NBTTagDouble(this.values[0]));
        list.func_74742_a((NBTBase)new NBTTagDouble(this.values[1]));
        nbtAS.func_74782_a("Values", (NBTBase)list);
        nbtAS.func_74778_a("Name", this.attr.func_111108_a());
        nbtAS.func_74780_a("Chance", this.chance);
        nbtAS.func_74768_a("Slot", this.slot);
        return nbtAS;
    }

    @Override
    public int getSlot() {
        return this.slot;
    }

    public void load(NBTTagCompound nbtAS) {
        double[] newVs = new double[2];
        for (int i = 0; i < 2; ++i) {
            newVs[i] = nbtAS.func_150295_c("Values", 6).func_150309_d(i);
        }
        this.values = newVs;
        this.setAttribute(nbtAS.func_74779_i("Name"));
        this.chance = nbtAS.func_74769_h("Chance");
        this.slot = nbtAS.func_74762_e("Slot");
    }

    @Override
    public void remove() {
        this.parent.removeAttribute(this);
    }

    @Override
    public void setAttribute(IAttribute attribute) {
        this.attr = attribute;
    }

    @Override
    public void setAttribute(String name) {
        switch (name) {
            case "generic.maxHealth": {
                this.attr = SharedMonsterAttributes.field_111267_a;
                break;
            }
            case "generic.followRange": {
                this.attr = SharedMonsterAttributes.field_111265_b;
                break;
            }
            case "generic.knockbackResistance": {
                this.attr = SharedMonsterAttributes.field_111266_c;
                break;
            }
            case "generic.movementSpeed": {
                this.attr = SharedMonsterAttributes.field_111263_d;
                break;
            }
            case "generic.attackDamage": {
                this.attr = SharedMonsterAttributes.field_111264_e;
                break;
            }
            case "generic.attackSpeed": {
                this.attr = SharedMonsterAttributes.field_188790_f;
                break;
            }
            case "generic.armor": {
                this.attr = SharedMonsterAttributes.field_188791_g;
                break;
            }
            case "generic.luck": {
                this.attr = SharedMonsterAttributes.field_188792_h;
                break;
            }
            default: {
                this.attr = new RangedAttribute(null, name, 0.0, -1024.0, 1024.0).func_111112_a(true);
            }
        }
    }

    @Override
    public void setChance(double chance) {
        double newChance = ValueUtil.correctDouble(chance, 1.0E-4, 100.0);
        this.chance = (double)Math.round(newChance * 10000.0) / 10000.0;
    }

    @Override
    public void setSlot(int slot) {
        if (slot < -1 || slot > 5) {
            throw new CustomNPCsException("Slot has to be between -1 and 5, given was: " + slot, new Object[0]);
        }
        this.slot = slot;
    }

    @Override
    public void setValues(double min, double max) {
        double newMin = min;
        double newMax = max;
        if (min > max) {
            newMin = max;
            newMax = min;
        }
        this.values = new double[]{newMin, newMax};
    }
}

